

#ifndef ADE9000_REG_MAP_API_MACROS_H
#define ADE9000_REG_MAP_API_MACROS_H

#ifdef __cplusplus
extern "c" {
#endif

#define ADDR_AIGAIN_STAGE1                   0x00000000            /*  Phase A current  single point gain */
#define ADDR_AIGAIN0                         0x00000001            /*  Phase A current  gain0 */
#define ADDR_AIGAIN1                         0x00000002            /*  Phase A current  gain1 */
#define ADDR_AIGAIN2                         0x00000003            /*  Phase A current  gain2 */
#define ADDR_AIGAIN3                         0x00000004            /*  Phase A current  gain3 */
#define ADDR_AIGAIN4                         0x00000005            /*  Phase A current  gain4 */
#define ADDR_AI_PCF_BETA0                    0x00000006            /*  Phase A compensation filter coefficient 0 */
#define ADDR_AI_PCF_BETA1                    0x00000007            /*  Phase A compensation filter coefficient 1 */
#define ADDR_AI_PCF_BETA2                    0x00000008            /*  Phase A compensation filter coefficient 2 */
#define ADDR_AI_PCF_BETA3                    0x00000009            /*  Phase A compensation filter coefficient 3 */
#define ADDR_AI_PCF_BETA4                    0x0000000A            /*  Phase A compensation filter coefficient 4 */
#define ADDR_AVGAIN                          0x0000000B            /*  Phase A voltage  gain */
#define ADDR_AIRMSOS                         0x0000000C            /*  Phase A current  RMS offset */
#define ADDR_AVRMSOS                         0x0000000D            /*  Phase A voltage  RMS offset */
#define ADDR_APGAIN                          0x0000000E            /*  Phase A power gain */
#define ADDR_AWATTOS                         0x0000000F            /*  Phase A Watt offset */
#define ADDR_AVAROS                          0x00000010            /*  Phase A VAR offset */
#define ADDR_AFWATTOS                        0x00000011            /*  Phase A fundamental Watt  offset */
#define ADDR_AFVAROS                         0x00000012            /*  Phase A fundamental VAR  offset */
#define ADDR_AIFRMSOS                        0x00000013            /*  Phase A current  fundamental  RMS offset */
#define ADDR_AVFRMSOS                        0x00000014            /*  Phase A voltage  fundamental  RMS offset */
#define ADDR_AV_LCRMS1_OS                    0x00000015            /*  Phase A voltage  1/2 line cycle RMS offset */
#define ADDR_AI_LCRMS1_OS                    0x00000016            /*  Phase A current  1/2 line cycle RMS offset */
#define ADDR_AV_LCRMS2_OS                    0x00000017            /*  Phase A voltage  10-12 line cycle RMS offset */
#define ADDR_AI_LCRMS2_OS                    0x00000018            /*  Phase A current  10-12 line cycle RMS offset */
#define ADDR_BIGAIN_STAGE1                   0x00000020            /*  Phase B current  single point gain */
#define ADDR_BIGAIN0                         0x00000021            /*  Phase B current  gain0 */
#define ADDR_BIGAIN1                         0x00000022            /*  Phase B current  gain1 */
#define ADDR_BIGAIN2                         0x00000023            /*  Phase B current  gain2 */
#define ADDR_BIGAIN3                         0x00000024            /*  Phase B current  gain3 */
#define ADDR_BIGAIN4                         0x00000025            /*  Phase B current  gain4 */
#define ADDR_BI_PCF_BETA0                    0x00000026            /*  Phase B compensation filter coefficient 0 */
#define ADDR_BI_PCF_BETA1                    0x00000027            /*  Phase B compensation filter coefficient 1 */
#define ADDR_BI_PCF_BETA2                    0x00000028            /*  Phase B compensation filter coefficient 2 */
#define ADDR_BI_PCF_BETA3                    0x00000029            /*  Phase B compensation filter coefficient 3 */
#define ADDR_BI_PCF_BETA4                    0x0000002A            /*  Phase B compensation filter coefficient 4 */
#define ADDR_BVGAIN                          0x0000002B            /*  Phase B voltage  gain */
#define ADDR_BIRMSOS                         0x0000002C            /*  Phase B current  RMS offset */
#define ADDR_BVRMSOS                         0x0000002D            /*  Phase B voltage  RMS offset */
#define ADDR_BPGAIN                          0x0000002E            /*  Phase B power gain */
#define ADDR_BWATTOS                         0x0000002F            /*  Phase B Watt offset */
#define ADDR_BVAROS                          0x00000030            /*  Phase B VAR offset */
#define ADDR_BFWATTOS                        0x00000031            /*  Phase B fundamental Watt  offset */
#define ADDR_BFVAROS                         0x00000032            /*  Phase B fundamental VAR  offset */
#define ADDR_BIFRMSOS                        0x00000033            /*  Phase B current  fundamental  RMS offset */
#define ADDR_BVFRMSOS                        0x00000034            /*  Phase B voltage  fundamental  RMS offset */
#define ADDR_BV_LCRMS1_OS                    0x00000035            /*  Phase B voltage  1/2 line cycle RMS offset */
#define ADDR_BI_LCRMS1_OS                    0x00000036            /*  Phase B current  1/2 line cycle RMS offset */
#define ADDR_BV_LCRMS2_OS                    0x00000037            /*  Phase B voltage  10-12 line cycle RMS offset */
#define ADDR_BI_LCRMS2_OS                    0x00000038            /*  Phase B current  10-12 line cycle RMS offset */
#define ADDR_CIGAIN_STAGE1                   0x00000040            /*  Phase C current  single point gain */
#define ADDR_CIGAIN0                         0x00000041            /*  Phase C current  gain0 */
#define ADDR_CIGAIN1                         0x00000042            /*  Phase C current  gain1 */
#define ADDR_CIGAIN2                         0x00000043            /*  Phase C current  gain2 */
#define ADDR_CIGAIN3                         0x00000044            /*  Phase C current  gain3 */
#define ADDR_CIGAIN4                         0x00000045            /*  Phase C current  gain4 */
#define ADDR_CI_PCF_BETA0                    0x00000046            /*  Phase C compensation filter coefficient 0 */
#define ADDR_CI_PCF_BETA1                    0x00000047            /*  Phase C compensation filter coefficient 1 */
#define ADDR_CI_PCF_BETA2                    0x00000048            /*  Phase C compensation filter coefficient 2 */
#define ADDR_CI_PCF_BETA3                    0x00000049            /*  Phase C compensation filter coefficient 3 */
#define ADDR_CI_PCF_BETA4                    0x0000004A            /*  Phase C compensation filter coefficient 4 */
#define ADDR_CVGAIN                          0x0000004B            /*  Phase C voltage  gain */
#define ADDR_CIRMSOS                         0x0000004C            /*  Phase C current  RMS offset */
#define ADDR_CVRMSOS                         0x0000004D            /*  Phase C voltage  RMS offset */
#define ADDR_CPGAIN                          0x0000004E            /*  Phase C power gain */
#define ADDR_CWATTOS                         0x0000004F            /*  Phase C Watt offset */
#define ADDR_CVAROS                          0x00000050            /*  Phase C VAR offset */
#define ADDR_CFWATTOS                        0x00000051            /*  Phase C fundamental Watt  offset */
#define ADDR_CFVAROS                         0x00000052            /*  Phase C fundamental VAR  offset */
#define ADDR_CIFRMSOS                        0x00000053            /*  Phase C current  fundamental  RMS offset */
#define ADDR_CVFRMSOS                        0x00000054            /*  Phase C voltage  fundamental  RMS offset */
#define ADDR_CV_LCRMS1_OS                    0x00000055            /*  Phase C voltage  1/2 line cycle RMS offset */
#define ADDR_CI_LCRMS1_OS                    0x00000056            /*  Phase C current  1/2 line cycle RMS offset */
#define ADDR_CV_LCRMS2_OS                    0x00000057            /*  Phase C voltage  10-12 line cycle RMS offset */
#define ADDR_CI_LCRMS2_OS                    0x00000058            /*  Phase C current  10-12 line cycle RMS offset */
#define ADDR_DSP_CFG1                        0x00000060            /*  DSP Firmware configuration */
#define ADDR_HYST_THR_L0                     0x00000061            /*  Hysteresis threshold 0 low */
#define ADDR_HYST_THR_L1                     0x00000062            /*  Hysteresis threshold 1 low */
#define ADDR_HYST_THR_L2                     0x00000063            /*  Hysteresis threshold 2 low */
#define ADDR_HYST_THR_L3                     0x00000064            /*  Hysteresis threshold 3 low */
#define ADDR_HYST_THR_L4                     0x00000065            /*  Hysteresis threshold 4 low */
#define ADDR_HYST_THR_H0                     0x00000066            /*  Hysteresis threshold 0 high */
#define ADDR_HYST_THR_H1                     0x00000067            /*  Hysteresis threshold 1 high */
#define ADDR_HYST_THR_H2                     0x00000068            /*  Hysteresis threshold 2 high */
#define ADDR_HYST_THR_H3                     0x00000069            /*  Hysteresis threshold 3 high */
#define ADDR_HYST_THR_H4                     0x0000006A            /*  Hysteresis threshold 4 high */
#define ADDR_NIRMSOS                         0x0000006B            /*  Neutral current  RMS offset */
#define ADDR_NSUMRMSOS                       0x0000006C            /*  Neutral current  sum RMS offset */
#define ADDR_NIGAIN                          0x0000006D            /*  Neutral current  gain */
#define ADDR_NI_PCF_BETA                     0x0000006E            /*  Neutral compensation filter coefficient */
#define ADDR_NI_LCRMS1_OS                    0x0000006F            /*  Neutral current  1/2 line cycle RMS offset */
#define ADDR_NI_LCRMS2_OS                    0x00000070            /*  Neutral current  10-12 line cycle RMS offset */
#define ADDR_VNOM                            0x00000071            /*  Nominal phase voltage rms */
#define ADDR_SCF_COEF                        0x00000072            /*  Didt sensor compensation filter coefficient */
#define ADDR_ISUMLVL                         0x00000073            /*  Threshold used in comparison between the sum of phase current  and the neutral current */
#define ADDR_AI_PCF                          0x0000020A            /*  Phase A current  data after phase compensation filter */
#define ADDR_AV_PCF                          0x0000020B            /*  Phase A voltage  data after phase compensation filter */
#define ADDR_AIRMS                           0x0000020C            /*  Phase A current  RMS */
#define ADDR_AVRMS                           0x0000020D            /*  Phase A voltage  RMS */
#define ADDR_AIFRMS                          0x0000020E            /*  Phase A current  fundamental RMS */
#define ADDR_AVFRMS                          0x0000020F            /*  Phase A voltage  fundamental RMS */
#define ADDR_AWATT                           0x00000210            /*  Phase A active power instantaneous value */
#define ADDR_AVAR                            0x00000211            /*  Phase A reactive power instantaneous value */
#define ADDR_AVA                             0x00000212            /*  Phase A apparent power instantaneous value */
#define ADDR_AFWATT                          0x00000213            /*  Phase A  fundamental active power instantaneous value */
#define ADDR_AFVAR                           0x00000214            /*  Phase A  fundamental reactive power instantaneous value */
#define ADDR_AFVA                            0x00000215            /*  Phase A  fundamental apparent power instantaneous value */
#define ADDR_APF                             0x00000216            /*  Phase A power factor */
#define ADDR_AVTHD                           0x00000217            /*  Phase A voltage THD */
#define ADDR_AITHD                           0x00000218            /*  Phase A current THD */
#define ADDR_AIRMS_ONECYCLE                  0x00000219            /*  Phase A current 1/2 line cycle RMS instantaneous value */
#define ADDR_AVRMS_ONECYCLE                  0x0000021A            /*  Phase A voltage 1/2 line cycle RMS instantaneous value */
#define ADDR_AIRMS_1012CYCLE                 0x0000021B            /*  Phase A current 10-12 line cycle RMS instantaneous value */
#define ADDR_AVRMS_1012CYCLE                 0x0000021C            /*  Phase A voltage 1012 line cycle RMS instantaneous value */
#define ADDR_A_MTGN_REGION                   0x0000021D            /*  Phase A multi-point region */
#define ADDR_BI_PCF                          0x0000022A            /*  Phase B current  data after phase compensation filter */
#define ADDR_BV_PCF                          0x0000022B            /*  Phase B voltage  data after phase compensation filter */
#define ADDR_BIRMS                           0x0000022C            /*  Phase B current  RMS */
#define ADDR_BVRMS                           0x0000022D            /*  Phase B voltage  RMS */
#define ADDR_BIFRMS                          0x0000022E            /*  Phase B current  fundamental RMS */
#define ADDR_BVFRMS                          0x0000022F            /*  Phase B voltage  fundamental RMS */
#define ADDR_BWATT                           0x00000230            /*  Phase B active power instantaneous value */
#define ADDR_BVAR                            0x00000231            /*  Phase B reactive power instantaneous value */
#define ADDR_BVA                             0x00000232            /*  Phase B apparent power instantaneous value */
#define ADDR_BFWATT                          0x00000233            /*  Phase B  fundamental active power instantaneous value */
#define ADDR_BFVAR                           0x00000234            /*  Phase B  fundamental reactive power instantaneous value */
#define ADDR_BFVA                            0x00000235            /*  Phase B  fundamental apparent power instantaneous value */
#define ADDR_BPF                             0x00000236            /*  Phase B power factor */
#define ADDR_BVTHD                           0x00000237            /*  Phase B voltage THD */
#define ADDR_BITHD                           0x00000238            /*  Phase B current THD */
#define ADDR_BIRMS_ONECYCLE                  0x00000239            /*  Phase B current 1/2 line cycle RMS instantaneous value */
#define ADDR_BVRMS_ONECYCLE                  0x0000023A            /*  Phase B voltage 1/2 line cycle RMS instantaneous value */
#define ADDR_BIRMS_1012CYCLE                 0x0000023B            /*  Phase B current 10-12 line cycle RMS instantaneous value */
#define ADDR_BVRMS_1012CYCLE                 0x0000023C            /*  Phase B voltage 1012 line cycle RMS instantaneous value */
#define ADDR_B_MTGN_REGION                   0x0000023D            /*  Phase B multi-point region */
#define ADDR_CI_PCF                          0x0000024A            /*  Phase C current  data after phase compensation filter */
#define ADDR_CV_PCF                          0x0000024B            /*  Phase C voltage  data after phase compensation filter */
#define ADDR_CIRMS                           0x0000024C            /*  Phase C current  RMS */
#define ADDR_CVRMS                           0x0000024D            /*  Phase C voltage  RMS */
#define ADDR_CIFRMS                          0x0000024E            /*  Phase C current  fundamental RMS */
#define ADDR_CVFRMS                          0x0000024F            /*  Phase C voltage  fundamental RMS */
#define ADDR_CWATT                           0x00000250            /*  Phase C active power instantaneous value */
#define ADDR_CVAR                            0x00000251            /*  Phase C reactive power instantaneous value */
#define ADDR_CVA                             0x00000252            /*  Phase C apparent power instantaneous value */
#define ADDR_CFWATT                          0x00000253            /*  Phase C  fundamental active power instantaneous value */
#define ADDR_CFVAR                           0x00000254            /*  Phase C  fundamental reactive power instantaneous value */
#define ADDR_CFVA                            0x00000255            /*  Phase C  fundamental apparent power instantaneous value */
#define ADDR_CPF                             0x00000256            /*  Phase C power factor */
#define ADDR_CVTHD                           0x00000257            /*  Phase C voltage THD */
#define ADDR_CITHD                           0x00000258            /*  Phase C current THD */
#define ADDR_CIRMS_ONECYCLE                  0x00000259            /*  Phase C current 1/2 line cycle RMS instantaneous value */
#define ADDR_CVRMS_ONECYCLE                  0x0000025A            /*  Phase C voltage 1/2 line cycle RMS instantaneous value */
#define ADDR_CIRMS_1012CYCLE                 0x0000025B            /*  Phase C current 10-12 line cycle RMS instantaneous value */
#define ADDR_CVRMS_1012CYCLE                 0x0000025C            /*  Phase C voltage 1012 line cycle RMS instantaneous value */
#define ADDR_C_MTGN_REGION                   0x0000025D            /*  Phase C multi-point region */
#define ADDR_NI_PCF                          0x00000265            /*  Neutral waveform value */
#define ADDR_NIRMS                           0x00000266            /*  Neutral current  RMS */
#define ADDR_NIRMS_ONECYCLE                  0x00000267            /*  Neutral current 1/2 line cycle RMS instantaneous value */
#define ADDR_NIRMS_1012CYCLE                 0x00000268            /*  Neutral current 10-12 line cycle RMS instantaneous value */
#define ADDR_ISUMRMS                         0x00000269            /*  Neutral current sum RMS */
#define ADDR_FW_VERSION                      0x0000026A            /*  Firmware version */
#define ADDR_AWATT_PWR_USER_HI               0x000002E5            /*  AWATT_PWR_USER_HI */
#define ADDR_AWATT_EGY_USER_LO               0x000002E6            /*  AWATT_EGY_USER_LO */
#define ADDR_AWATT_EGY_USER_HI               0x000002E7            /*  AWATT_EGY_USER_HI */
#define ADDR_AVAR_PWR_USER_HI                0x000002EF            /*  AVAR_PWR_USER_HI */
#define ADDR_AVAR_EGY_USER_LO                0x000002F0            /*  AVAR_EGY_USER_LO */
#define ADDR_AVAR_EGY_USER_HI                0x000002F1            /*  AVAR_EGY_USER_HI */
#define ADDR_AVA_PWR_USER_HI                 0x000002F9            /*  AVA_PWR_USER_HI */
#define ADDR_AVA_EGY_USER_LO                 0x000002FA            /*  AVA_EGY_USER_LO */
#define ADDR_AVA_EGY_USER_HI                 0x000002FB            /*  AVA_EGY_USER_HI */
#define ADDR_AFWATT_PWR_USER_HI              0x00000303            /*  AFWATT_PWR_USER_HI */
#define ADDR_AFWATT_EGY_USER_LO              0x00000304            /*  AFWATT_EGY_USER_LO */
#define ADDR_AFWATT_EGY_USER_HI              0x00000305            /*  AFWATT_EGY_USER_HI */
#define ADDR_AFVAR_PWR_USER_HI               0x0000030D            /*  AFVAR_PWR_USER_HI */
#define ADDR_AFVAR_EGY_USER_LO               0x0000030E            /*  AFVAR_EGY_USER_LO */
#define ADDR_AFVAR_EGY_USER_HI               0x0000030F            /*  AFVAR_EGY_USER_HI */
#define ADDR_AFVA_PWR_USER_HI                0x00000317            /*  AFVA_PWR_USER_HI */
#define ADDR_AFVA_EGY_USER_LO                0x00000318            /*  AFVA_EGY_USER_LO */
#define ADDR_AFVA_EGY_USER_HI                0x00000319            /*  AFVA_EGY_USER_HI */
#define ADDR_BWATT_PWR_USER_HI               0x00000321            /*  BWATT_PWR_USER_HI */
#define ADDR_BWATT_EGY_USER_LO               0x00000322            /*  BWATT_EGY_USER_LO */
#define ADDR_BWATT_EGY_USER_HI               0x00000323            /*  BWATT_EGY_USER_HI */
#define ADDR_BVAR_PWR_USER_HI                0x0000032B            /*  BVAR_PWR_USER_HI */
#define ADDR_BVAR_EGY_USER_LO                0x0000032C            /*  BVAR_EGY_USER_LO */
#define ADDR_BVAR_EGY_USER_HI                0x0000032D            /*  BVAR_EGY_USER_HI */
#define ADDR_BVA_PWR_USER_HI                 0x00000335            /*  BVA_PWR_USER_HI */
#define ADDR_BVA_EGY_USER_LO                 0x00000336            /*  BVA_EGY_USER_LO */
#define ADDR_BVA_EGY_USER_HI                 0x00000337            /*  BVA_EGY_USER_HI */
#define ADDR_BFWATT_PWR_USER_HI              0x0000033F            /*  BFWATT_PWR_USER_HI */
#define ADDR_BFWATT_EGY_USER_LO              0x00000340            /*  BFWATT_EGY_USER_LO */
#define ADDR_BFWATT_EGY_USER_HI              0x00000341            /*  BFWATT_EGY_USER_HI */
#define ADDR_BFVAR_PWR_USER_HI               0x00000349            /*  BFVAR_PWR_USER_HI */
#define ADDR_BFVAR_EGY_USER_LO               0x0000034A            /*  BFVAR_EGY_USER_LO */
#define ADDR_BFVAR_EGY_USER_HI               0x0000034B            /*  BFVAR_EGY_USER_HI */
#define ADDR_BFVA_PWR_USER_HI                0x00000353            /*  BFVA_PWR_USER_HI */
#define ADDR_BFVA_EGY_USER_LO                0x00000354            /*  BFVA_EGY_USER_LO */
#define ADDR_BFVA_EGY_USER_HI                0x00000355            /*  BFVA_EGY_USER_HI */
#define ADDR_CWATT_PWR_USER_HI               0x0000035D            /*  CWATT_PWR_USER_HI */
#define ADDR_CWATT_EGY_USER_LO               0x0000035E            /*  CWATT_EGY_USER_LO */
#define ADDR_CWATT_EGY_USER_HI               0x0000035F            /*  CWATT_EGY_USER_HI */
#define ADDR_CVAR_PWR_USER_HI                0x00000367            /*  CVAR_PWR_USER_HI */
#define ADDR_CVAR_EGY_USER_LO                0x00000368            /*  CVAR_EGY_USER_LO */
#define ADDR_CVAR_EGY_USER_HI                0x00000369            /*  CVAR_EGY_USER_HI */
#define ADDR_CVA_PWR_USER_HI                 0x00000371            /*  CVA_PWR_USER_HI */
#define ADDR_CVA_EGY_USER_LO                 0x00000372            /*  CVA_EGY_USER_LO */
#define ADDR_CVA_EGY_USER_HI                 0x00000373            /*  CVA_EGY_USER_HI */
#define ADDR_CFWATT_PWR_USER_HI              0x0000037B            /*  CFWATT_PWR_USER_HI */
#define ADDR_CFWATT_EGY_USER_LO              0x0000037C            /*  CFWATT_EGY_USER_LO */
#define ADDR_CFWATT_EGY_USER_HI              0x0000037D            /*  CFWATT_EGY_USER_HI */
#define ADDR_CFVAR_PWR_USER_HI               0x00000385            /*  CFVAR_PWR_USER_HI */
#define ADDR_CFVAR_EGY_USER_LO               0x00000386            /*  CFVAR_EGY_USER_LO */
#define ADDR_CFVAR_EGY_USER_HI               0x00000387            /*  CFVAR_EGY_USER_HI */
#define ADDR_CFVA_PWR_USER_HI                0x0000038F            /*  CFVA_PWR_USER_HI */
#define ADDR_CFVA_EGY_USER_LO                0x00000390            /*  CFVA_EGY_USER_LO */
#define ADDR_CFVA_EGY_USER_HI                0x00000391            /*  CFVA_EGY_USER_HI */
#define ADDR_PWATT_USER_HI                   0x00000397            /*  PWATT_USER_HI */
#define ADDR_NWATT_USER_HI                   0x0000039B            /*  NWATT_USER_HI */
#define ADDR_PVAR_USER_HI                    0x0000039F            /*  PVAR_USER_HI */
#define ADDR_NVAR_USER_HI                    0x000003A3            /*  NVAR_USER_HI */
#define ADDR_IPEAK                           0x00000400            /*  Current peak value */
#define ADDR_VPEAK                           0x00000401            /*  Voltage peak value */
#define ADDR_STATUS0                         0x00000402            /*  Interrupt status register 0 */
#define ADDR_STATUS1                         0x00000403            /*  Interrupt status register 1 */
#define ADDR_PQSTATUS                        0x00000404            /*  Event status */
#define ADDR_MASK0                           0x00000405            /*  Interrupt enable register 0 */
#define ADDR_MASK1                           0x00000406            /*  Interrupt enable register 1 */
#define ADDR_PQMASK                          0x00000407            /*  Power Quality interrupt enable register */
#define ADDR_OILVL                           0x00000409            /*  Over current detection threshold level */
#define ADDR_OIA                             0x0000040A            /*  Phase A over current register */
#define ADDR_OIB                             0x0000040B            /*  Phase B over current register */
#define ADDR_OIC                             0x0000040C            /*  Phase C over current register */
#define ADDR_OIN                             0x0000040D            /*  Phase N over current register */
#define ADDR_VPERIOD                         0x0000040E            /*  Voltage  period register */
#define ADDR_VLEVEL                          0x0000040F            /*  DSP PLL voltage level */
#define ADDR_DIP_LVL                         0x00000410            /*  Dip detection threshold level */
#define ADDR_DIPA                            0x00000411            /*  Phase A half-cycle RMS value when the phase enter dip condition */
#define ADDR_DIPB                            0x00000412            /*  Phase B half-cycle RMS value when the phase enter dip condition */
#define ADDR_DIPC                            0x00000413            /*  Phase C half-cycle RMS value when the phase enter dip condition */
#define ADDR_SWELL_LVL                       0x00000414            /*  Swell detection threshold level */
#define ADDR_SWELLA                          0x00000415            /*  Phase A half-cycle RMS value when the phase enter swell condition */
#define ADDR_SWELLB                          0x00000416            /*  Phase B half-cycle RMS value when the phase enter swell condition */
#define ADDR_SWELLC                          0x00000417            /*  Phase C half-cycle RMS value when the phase enter swell condition */
#define ADDR_APERIOD                         0x00000418            /*  Time delay between phase A voltage ZX */
#define ADDR_BPERIOD                         0x00000419            /*  Time delay between phase B voltage ZX */
#define ADDR_CPERIOD                         0x0000041A            /*  Time delay between phase C voltage ZX */
#define ADDR_COM_PERIOD                      0x0000041B            /*  Time delay between combination voltage ZX */
#define ADDR_ACT_NL_LVL                      0x0000041C            /*  Noload threshold used for total/fund active power */
#define ADDR_REACT_NL_LVL                    0x0000041D            /*  Noload threshold used for total/fund reactive power */
#define ADDR_APP_NL_LVL                      0x0000041E            /*  Noload threshold used for total/fund apparent power */
#define ADDR_PHNOLOAD                        0x0000041F            /*  Phase noload */
#define ADDR_WTHR                            0x00000420            /*  CF threshold used for total/fund active power */
#define ADDR_VARTHR                          0x00000421            /*  CF threshold used for total/fund reactive power */
#define ADDR_VATHR                           0x00000422            /*  CF threshold used for total/fund apparent power */
#define ADDR_LAST_DATA                       0x00000423            /*  SPI transition last data */
#define ADDR_BSDIN_CFG                       0x00000424            /*  Bitstream data in config register */
#define ADDR_CF_LCFG                         0x00000425            /*  CF low pulse width configuration */
#define ADDR_TRIM2                           0x00000472            /*  OTPC trim read value */
#define ADDR_TRIM4                           0x00000474            /*  OTPC trim read value */
#define ADDR_DSP_RUN                         0x00000480            /*  DSP control register. */
#define ADDR_CONFIG1                         0x00000481            /*  General configuration register 1 */
#define ADDR_ANGL0_V2V                       0x00000482            /*  Time delay between phase A voltage and phase B voltage */
#define ADDR_ANGL1_V2V                       0x00000483            /*  Time delay between phase B voltage and phase C voltage */
#define ADDR_ANGL2_V2V                       0x00000484            /*  Time delay between phase A voltage and phase C voltage */
#define ADDR_ANGL0_V2I                       0x00000485            /*  Time delay between phase A voltage and phase A current */
#define ADDR_ANGL1_V2I                       0x00000486            /*  Time delay between phase B voltage and phase B current */
#define ADDR_ANGL2_V2I                       0x00000487            /*  Time delay between phase C voltage and phase C current */
#define ADDR_ANGL0_I2I                       0x00000488            /*  Time delay between phase A current and phase B current */
#define ADDR_ANGL1_I2I                       0x00000489            /*  Time delay between phase B current and phase C current */
#define ADDR_ANGL2_I2I                       0x0000048A            /*  Time delay between phase A current and phase C current */
#define ADDR_DIP_CYC                         0x0000048B            /*  Dip detection line cycle count */
#define ADDR_SWELL_CYC                       0x0000048C            /*  Swell detection line cycle count */
#define ADDR_PHSTATUS                        0x0000048F            /*  Phase status register */
#define ADDR_CFMODE                          0x00000490            /*  CFx configuration register */
#define ADDR_COMPMODE                        0x00000491            /*  Computation mode register */
#define ADDR_ACCMODE                         0x00000492            /*  Accumulation mode register */
#define ADDR_MMODE                           0x00000493            /*  Measurement mode register */
#define ADDR_CF1DEN                          0x00000494            /*  CF1 denominator register. */
#define ADDR_CF2DEN                          0x00000495            /*  CF2 denominator register. */
#define ADDR_CF3DEN                          0x00000496            /*  CF3 denominator register. */
#define ADDR_CF4DEN                          0x00000497            /*  CF4 denominator register. */
#define ADDR_ZXTOUT                          0x00000498            /*  Zero-crossing timeout count */
#define ADDR_ZXTHRSH                         0x00000499            /*  Voltage channel Zero-crossing threshold register */
#define ADDR_ZX_CFG                          0x0000049A            /*  Zero-crossing detect configuration register */
#define ADDR_SEQ_CYC                         0x0000049C            /*  Line cycle number used for phase sequence detection */
#define ADDR_PHSIGN                          0x0000049D            /*  Power signed register */
#define ADDR_WFB_CFG                         0x000004A0            /*  Waveform buffer configuration */
#define ADDR_WFB_PG_IRQEN                    0x000004A1            /*  Waveform buffer pages done irq enable. */
#define ADDR_WFB_TRG_CFG                     0x000004A2            /*  Waveform buffer trigger source enables */
#define ADDR_WFB_TRG_STAT                    0x000004A3            /*  Waveform buffer stop trigger status */
#define ADDR_ZX12P5MS                        0x000004A4            /*  Waveform buffer stop trigger status */
#define ADDR_CRC_STATIC_RSLT                 0x000004A8            /*  Static crc result */
#define ADDR_CRC_SPI_RSLT                    0x000004A9            /*  SPI traffic crc result */
#define ADDR_LAST_DATA_16                    0x000004AC            /*  Last data of 16 bit spi transition */
#define ADDR_LAST_CMD                        0x000004AE            /*  SPI transition last command */
#define ADDR_CONFIG2                         0x000004AF            /*  Configuration register 2 */
#define ADDR_EP_CFG                          0x000004B0            /*  Energy and power accumulator configuration */
#define ADDR_PWR_TIME                        0x000004B1            /*  Power accumulation timer */
#define ADDR_EGY_TIME                        0x000004B2            /*  Energy accumulation timer */
#define ADDR_CONFIG4                         0x000004B4            /*  Config4 */
#define ADDR_CONFIG_STC_CRC                  0x000004B5            /*  Config static crc registers */
#define ADDR_CONFIG_TSENS                    0x000004B6            /*  Temp sensor config */
#define ADDR_TSENS_RESULT                    0x000004B7            /*  Temp sensor result */
#define ADDR_CONFIG_3V3                      0x000004B8            /*  Config for 3v3 specific registers - retained in PSM2/PSM3 */
#define ADDR_PGA_GAIN                        0x000004B9            /*  I and v pga gains */
#define ADDR_CHNL_DIS                        0x000004BA            /*  Channel ADC disable */
#define ADDR_WR_LOCK                         0x000004BF            /*  Register write lock */
#define ADDR_DSP_RSV_IN                      0x000004E0            /*  DSP gpio in data */
#define ADDR_ECC_ERROR_ADDR                  0x000004F0            /*  Read only ecc error address */
#define ADDR_CHIP_REV                        0x000004FE            /*  Chip revision ID */
#define ADDR_IA_SC_DAT                       0x00000500            /*  Current A channel ADC data output from SINC filter 32K */
#define ADDR_VA_SC_DAT                       0x00000501            /*  Voltage A channel ADC data output from SINC filter 32K */
#define ADDR_IB_SC_DAT                       0x00000502            /*  Current B channel ADC data output from SINC filter 32K */
#define ADDR_VB_SC_DAT                       0x00000503            /*  Voltage B channel ADC data output from SINC filter 32K */
#define ADDR_IC_SC_DAT                       0x00000504            /*  Current C channel ADC data output from SINC filter 32K */
#define ADDR_VC_SC_DAT                       0x00000505            /*  Voltage C channel ADC data output from SINC filter 32K */
#define ADDR_IN_SC_DAT                       0x00000506            /*  Current Neutral channel ADC data output from SINC filter 32K */
#define ADDR_IA_ADC_DAT                      0x00000510            /*  Current A channel ADC data 8K */
#define ADDR_VA_ADC_DAT                      0x00000511            /*  Voltage A channel ADC data 8K */
#define ADDR_IB_ADC_DAT                      0x00000512            /*  Current B channel ADC data 8K */
#define ADDR_VB_ADC_DAT                      0x00000513            /*  Voltage B channel ADC data 8K */
#define ADDR_IC_ADC_DAT                      0x00000514            /*  Current C channel ADC data 8K */
#define ADDR_VC_ADC_DAT                      0x00000515            /*  Voltage C channel ADC data 8K */
#define ADDR_IN_ADC_DAT                      0x00000516            /*  Current Neutral channel ADC data 8K */
#define ADDR_AV_PCF_1                        0x00000600            /*  SPI Burst Read Accessible. Registers organized functionally. See AV_PCF. */
#define ADDR_BV_PCF_1                        0x00000601            /*  SPI Burst Read Accessible. Registers organized functionally. See BV_PCF. */
#define ADDR_CV_PCF_1                        0x00000602            /*  SPI Burst Read Accessible. Registers organized functionally. See CV_PCF. */
#define ADDR_NI_PCF_1                        0x00000603            /*  SPI Burst Read Accessible. Registers organized functionally. See NI_PCF. */
#define ADDR_AI_PCF_1                        0x00000604            /*  SPI Burst Read Accessible. Registers organized functionally. See AI_PCF. */
#define ADDR_BI_PCF_1                        0x00000605            /*  SPI Burst Read Accessible. Registers organized functionally. See BI_PCF. */
#define ADDR_CI_PCF_1                        0x00000606            /*  SPI Burst Read Accessible. Registers organized functionally. See CI_PCF. */
#define ADDR_AIRMS_1                         0x00000607            /*  SPI Burst Read Accessible. Registers organized functionally. See AIRMS. */
#define ADDR_BIRMS_1                         0x00000608            /*  SPI Burst Read Accessible. Registers organized functionally. See BIRMS. */
#define ADDR_CIRMS_1                         0x00000609            /*  SPI Burst Read Accessible. Registers organized functionally. See CIRMS. */
#define ADDR_AVRMS_1                         0x0000060A            /*  SPI Burst Read Accessible. Registers organized functionally. See AVRMS. */
#define ADDR_BVRMS_1                         0x0000060B            /*  SPI Burst Read Accessible. Registers organized functionally. See BVRMS. */
#define ADDR_CVRMS_1                         0x0000060C            /*  SPI Burst Read Accessible. Registers organized functionally. See CVRMS. */
#define ADDR_NIRMS_1                         0x0000060D            /*  SPI Burst Read Accessible. Registers organized functionally. See NIRMS. */
#define ADDR_AWATT_1                         0x0000060E            /*  SPI Burst Read Accessible. Registers organized functionally. See AWATT. */
#define ADDR_BWATT_1                         0x0000060F            /*  SPI Burst Read Accessible. Registers organized functionally. See BWATT. */
#define ADDR_CWATT_1                         0x00000610            /*  SPI Burst Read Accessible. Registers organized functionally. See CWATT. */
#define ADDR_AVA_1                           0x00000611            /*  SPI Burst Read Accessible. Registers organized functionally. See AVA. */
#define ADDR_BVA_1                           0x00000612            /*  SPI Burst Read Accessible. Registers organized functionally. See BVA. */
#define ADDR_CVA_1                           0x00000613            /*  SPI Burst Read Accessible. Registers organized functionally. See CVA. */
#define ADDR_AVAR_1                          0x00000614            /*  SPI Burst Read Accessible. Registers organized functionally. See AVAR. */
#define ADDR_BVAR_1                          0x00000615            /*  SPI Burst Read Accessible. Registers organized functionally. See BVAR. */
#define ADDR_CVAR_1                          0x00000616            /*  SPI Burst Read Accessible. Registers organized functionally. See CVAR. */
#define ADDR_AFVAR_1                         0x00000617            /*  SPI Burst Read Accessible. Registers organized functionally. See AFVAR. */
#define ADDR_BFVAR_1                         0x00000618            /*  SPI Burst Read Accessible. Registers organized functionally. See BFVAR. */
#define ADDR_CFVAR_1                         0x00000619            /*  SPI Burst Read Accessible. Registers organized functionally. See CFVAR. */
#define ADDR_APF_1                           0x0000061A            /*  SPI Burst Read Accessible. Registers organized functionally. See APF. */
#define ADDR_BPF_1                           0x0000061B            /*  SPI Burst Read Accessible. Registers organized functionally. See BPF. */
#define ADDR_CPF_1                           0x0000061C            /*  SPI Burst Read Accessible. Registers organized functionally. See CPF. */
#define ADDR_AVTHD_1                         0x0000061D            /*  SPI Burst Read Accessible. Registers organized functionally. See AVTHD. */
#define ADDR_BVTHD_1                         0x0000061E            /*  SPI Burst Read Accessible. Registers organized functionally. See BVTHD. */
#define ADDR_CVTHD_1                         0x0000061F            /*  SPI Burst Read Accessible. Registers organized functionally. See CVTHD. */
#define ADDR_AITHD_1                         0x00000620            /*  SPI Burst Read Accessible. Registers organized functionally. See AITHD. */
#define ADDR_BITHD_1                         0x00000621            /*  SPI Burst Read Accessible. Registers organized functionally. See BITHD. */
#define ADDR_CITHD_1                         0x00000622            /*  SPI Burst Read Accessible. Registers organized functionally. See CITHD. */
#define ADDR_AFWATT_1                        0x00000623            /*  SPI Burst Read Accessible. Registers organized functionally. See AFWATT. */
#define ADDR_BFWATT_1                        0x00000624            /*  SPI Burst Read Accessible. Registers organized functionally. See BFWATT. */
#define ADDR_CFWATT_1                        0x00000625            /*  SPI Burst Read Accessible. Registers organized functionally. See CFWATT. */
#define ADDR_AFVA_1                          0x00000626            /*  SPI Burst Read Accessible. Registers organized functionally. See AFVA. */
#define ADDR_BFVA_1                          0x00000627            /*  SPI Burst Read Accessible. Registers organized functionally. See BFVA. */
#define ADDR_CFVA_1                          0x00000628            /*  SPI Burst Read Accessible. Registers organized functionally. See CFVA. */
#define ADDR_AFIRMS_1                        0x00000629            /*  SPI Burst Read Accessible. Registers organized functionally. See AFIRMS. */
#define ADDR_BFIRMS_1                        0x0000062A            /*  SPI Burst Read Accessible. Registers organized functionally. See BFIRMS. */
#define ADDR_CFIRMS_1                        0x0000062B            /*  SPI Burst Read Accessible. Registers organized functionally. See CFIRMS. */
#define ADDR_AFVRMS_1                        0x0000062C            /*  SPI Burst Read Accessible. Registers organized functionally. See AFVRMS. */
#define ADDR_BFVRMS_1                        0x0000062D            /*  SPI Burst Read Accessible. Registers organized functionally. See BFVRMS. */
#define ADDR_CFVRMS_1                        0x0000062E            /*  SPI Burst Read Accessible. Registers organized functionally. See CFVRMS. */
#define ADDR_AIRMSONE_1                      0x0000062F            /*  SPI Burst Read Accessible. Registers organized functionally. See AIRMSONE. */
#define ADDR_BIRMSONE_1                      0x00000630            /*  SPI Burst Read Accessible. Registers organized functionally. See BIRMSONE. */
#define ADDR_CIRMSONE_1                      0x00000631            /*  SPI Burst Read Accessible. Registers organized functionally. See CIRMSONE. */
#define ADDR_AVRMSONE_1                      0x00000632            /*  SPI Burst Read Accessible. Registers organized functionally. See AVRMSONE. */
#define ADDR_BVRMSONE_1                      0x00000633            /*  SPI Burst Read Accessible. Registers organized functionally. See BVRMSONE. */
#define ADDR_CVRMSONE_1                      0x00000634            /*  SPI Burst Read Accessible. Registers organized functionally. See CVRMSONE. */
#define ADDR_NIRMSONE_1                      0x00000635            /*  SPI Burst Read Accessible. Registers organized functionally. See NIRMSONE. */
#define ADDR_AIRMS1012_1                     0x00000636            /*  SPI Burst Read Accessible. Registers organized functionally. See AIRMS1012. */
#define ADDR_BIRMS1012_1                     0x00000637            /*  SPI Burst Read Accessible. Registers organized functionally. See BIRMS1012. */
#define ADDR_CIRMS1012_1                     0x00000638            /*  SPI Burst Read Accessible. Registers organized functionally. See CIRMS1012. */
#define ADDR_AVRMS1012_1                     0x00000639            /*  SPI Burst Read Accessible. Registers organized functionally. See AVRMS1012. */
#define ADDR_BVRMS1012_1                     0x0000063A            /*  SPI Burst Read Accessible. Registers organized functionally. See BVRMS1012. */
#define ADDR_CVRMS1012_1                     0x0000063B            /*  SPI Burst Read Accessible. Registers organized functionally. See CVRMS1012. */
#define ADDR_NIRMS1012_1                     0x0000063C            /*  SPI Burst Read Accessible. Registers organized functionally. See NIRMS1012. */
#define ADDR_AV_PCF_2                        0x00000680            /*  SPI Burst Read Accessible. Registers organized by phase. See AV_PCF. */
#define ADDR_AI_PCF_2                        0x00000681            /*  SPI Burst Read Accessible. Registers organized by phase. See AI_PCF. */
#define ADDR_AIRMS_2                         0x00000682            /*  SPI Burst Read Accessible. Registers organized by phase. See AIRMS. */
#define ADDR_AVRMS_2                         0x00000683            /*  SPI Burst Read Accessible. Registers organized by phase. See AVRMS. */
#define ADDR_AWATT_2                         0x00000684            /*  SPI Burst Read Accessible. Registers organized by phase. See AWATT. */
#define ADDR_AVA_2                           0x00000685            /*  SPI Burst Read Accessible. Registers organized by phase. See AVA. */
#define ADDR_AVAR_2                          0x00000686            /*  SPI Burst Read Accessible. Registers organized by phase. See AVAR. */
#define ADDR_AFVAR_2                         0x00000687            /*  SPI Burst Read Accessible. Registers organized by phase. See AFVAR. */
#define ADDR_APF_2                           0x00000688            /*  SPI Burst Read Accessible. Registers organized by phase. See APF. */
#define ADDR_AVTHD_2                         0x00000689            /*  SPI Burst Read Accessible. Registers organized by phase. See AVTHD. */
#define ADDR_AITHD_2                         0x0000068A            /*  SPI Burst Read Accessible. Registers organized by phase. See AITHD. */
#define ADDR_AFWATT_2                        0x0000068B            /*  SPI Burst Read Accessible. Registers organized by phase. See AFWATT. */
#define ADDR_AFVA_2                          0x0000068C            /*  SPI Burst Read Accessible. Registers organized by phase. See AFVA. */
#define ADDR_AFIRMS_2                        0x0000068D            /*  SPI Burst Read Accessible. Registers organized by phase. See AFIRMS. */
#define ADDR_AFVRMS_2                        0x0000068E            /*  SPI Burst Read Accessible. Registers organized by phase. See AFVRMS. */
#define ADDR_AIRMSONE_2                      0x0000068F            /*  SPI Burst Read Accessible. Registers organized by phase. See AIRMSONE. */
#define ADDR_AVRMSONE_2                      0x00000690            /*  SPI Burst Read Accessible. Registers organized by phase. See AVRMSONE. */
#define ADDR_AIRMS1012_2                     0x00000691            /*  SPI Burst Read Accessible. Registers organized by phase. See AIRMS1012. */
#define ADDR_AVRMS1012_2                     0x00000692            /*  SPI Burst Read Accessible. Registers organized by phase. See AVRMS1012. */
#define ADDR_BV_PCF_2                        0x00000693            /*  SPI Burst Read Accessible. Registers organized by phase. See BV_PCF. */
#define ADDR_BI_PCF_2                        0x00000694            /*  SPI Burst Read Accessible. Registers organized by phase. See BI_PCF. */
#define ADDR_BIRMS_2                         0x00000695            /*  SPI Burst Read Accessible. Registers organized by phase. See BIRMS. */
#define ADDR_BVRMS_2                         0x00000696            /*  SPI Burst Read Accessible. Registers organized by phase. See BVRMS. */
#define ADDR_BWATT_2                         0x00000697            /*  SPI Burst Read Accessible. Registers organized by phase. See BWATT. */
#define ADDR_BVA_2                           0x00000698            /*  SPI Burst Read Accessible. Registers organized by phase. See BVA. */
#define ADDR_BVAR_2                          0x00000699            /*  SPI Burst Read Accessible. Registers organized by phase. See BVAR. */
#define ADDR_BFVAR_2                         0x0000069A            /*  SPI Burst Read Accessible. Registers organized by phase. See BFVAR. */
#define ADDR_BPF_2                           0x0000069B            /*  SPI Burst Read Accessible. Registers organized by phase. See BPF. */
#define ADDR_BVTHD_2                         0x0000069C            /*  SPI Burst Read Accessible. Registers organized by phase. See BVTHD. */
#define ADDR_BITHD_2                         0x0000069D            /*  SPI Burst Read Accessible. Registers organized by phase. See BITHD. */
#define ADDR_BFWATT_2                        0x0000069E            /*  SPI Burst Read Accessible. Registers organized by phase. See BFWATT. */
#define ADDR_BFVA_2                          0x0000069F            /*  SPI Burst Read Accessible. Registers organized by phase. See BFVA. */
#define ADDR_BFIRMS_2                        0x000006A0            /*  SPI Burst Read Accessible. Registers organized by phase. See BFIRMS. */
#define ADDR_BFVRMS_2                        0x000006A1            /*  SPI Burst Read Accessible. Registers organized by phase. See BFVRMS. */
#define ADDR_BIRMSONE_2                      0x000006A2            /*  SPI Burst Read Accessible. Registers organized by phase. See BIRMSONE. */
#define ADDR_BVRMSONE_2                      0x000006A3            /*  SPI Burst Read Accessible. Registers organized by phase. See BVRMSONE. */
#define ADDR_BIRMS1012_2                     0x000006A4            /*  SPI Burst Read Accessible. Registers organized by phase. See BIRMS1012. */
#define ADDR_BVRMS1012_2                     0x000006A5            /*  SPI Burst Read Accessible. Registers organized by phase. See BVRMS1012. */
#define ADDR_CV_PCF_2                        0x000006A6            /*  SPI Burst Read Accessible. Registers organized by phase. See CV_PCF. */
#define ADDR_CI_PCF_2                        0x000006A7            /*  SPI Burst Read Accessible. Registers organized by phase. See CI_PCF. */
#define ADDR_CIRMS_2                         0x000006A8            /*  SPI Burst Read Accessible. Registers organized by phase. See CIRMS. */
#define ADDR_CVRMS_2                         0x000006A9            /*  SPI Burst Read Accessible. Registers organized by phase. See CVRMS. */
#define ADDR_CWATT_2                         0x000006AA            /*  SPI Burst Read Accessible. Registers organized by phase. See CWATT. */
#define ADDR_CVA_2                           0x000006AB            /*  SPI Burst Read Accessible. Registers organized by phase. See CVA. */
#define ADDR_CVAR_2                          0x000006AC            /*  SPI Burst Read Accessible. Registers organized by phase. See CVAR. */
#define ADDR_CFVAR_2                         0x000006AD            /*  SPI Burst Read Accessible. Registers organized by phase. See CFVAR. */
#define ADDR_CPF_2                           0x000006AE            /*  SPI Burst Read Accessible. Registers organized by phase. See CPF. */
#define ADDR_CVTHD_2                         0x000006AF            /*  SPI Burst Read Accessible. Registers organized by phase. See CVTHD. */
#define ADDR_CITHD_2                         0x000006B0            /*  SPI Burst Read Accessible. Registers organized by phase. See CITHD. */
#define ADDR_CFWATT_2                        0x000006B1            /*  SPI Burst Read Accessible. Registers organized by phase. See CFWATT. */
#define ADDR_CFVA_2                          0x000006B2            /*  SPI Burst Read Accessible. Registers organized by phase. See CFVA. */
#define ADDR_CFIRMS_2                        0x000006B3            /*  SPI Burst Read Accessible. Registers organized by phase. See CFIRMS. */
#define ADDR_CFVRMS_2                        0x000006B4            /*  SPI Burst Read Accessible. Registers organized by phase. See CFVRMS. */
#define ADDR_CIRMSONE_2                      0x000006B5            /*  SPI Burst Read Accessible. Registers organized by phase. See CIRMSONE. */
#define ADDR_CVRMSONE_2                      0x000006B6            /*  SPI Burst Read Accessible. Registers organized by phase. See CVRMSONE. */
#define ADDR_CIRMS1012_2                     0x000006B7            /*  SPI Burst Read Accessible. Registers organized by phase. See CIRMS1012. */
#define ADDR_CVRMS1012_2                     0x000006B8            /*  SPI Burst Read Accessible. Registers organized by phase. See CVRMS1012. */
#define ADDR_NI_PCF_2                        0x000006B9            /*  SPI Burst Read Accessible. Registers organized by phase. See NI_PCF. */
#define ADDR_NIRMS_2                         0x000006BA            /*  SPI Burst Read Accessible. Registers organized by phase. See NIRMS. */
#define ADDR_NIRMSONE_2                      0x000006BB            /*  SPI Burst Read Accessible. Registers organized by phase. See NIRMSONE. */
#define ADDR_NIRMS1012_2                     0x000006BC            /*  SPI Burst Read Accessible. Registers organized by phase. See NIRMS1012. */

#ifdef __cplusplus
}
#endif

#endif	/* end ifndef ADE9000_REG_MAP_API_MACROS_H */
